//
//  MyItem.m
//  XNJB
//
//  Created by Richard Low on 07/09/2004.
//

/* This class is used my MyMutableArray for the 
 * sortable elements of the array. Provides methods
 * for sorting unsigned ints and NSStrings.
 * Also declares a method matchesString to see
 * if this item contains a string. This is to be
 * implemented by super classes (e.g. Track or DataFile).
 */

#import "MyItem.h"
// for sortDirections
#import "MyMutableArray.h"

/* these are declared in MyMutableArray.m as a way of telling 
 * the items which direction to sort in
 */
extern sortDirections sortDirection;
/* and which sort selector to use if we find two elements NSOrderedSame */
extern SEL sortSelector;

@implementation MyItem

/* To be implemented by super class.
 * Method to search self for NSString search
 */
- (BOOL)matchesString:(NSString *)search
{
	return YES;
}

/* this compares the two unsigned ints mine and theirs
 * if the two are the same, we compare self with other using
 * the sort selector newSortSelector
 */
- (NSComparisonResult)compareUnsignedInts:(unsigned)mine withOther:(unsigned)theirs withItem:(MyItem *)other withSortSelector:(SEL)newSortSelector
{
	switch (sortDirection)
	{
		case SORT_ASCENDING:
			if (mine == theirs)
				if (sortSelector != nil && sortSelector != newSortSelector)
					return (NSComparisonResult)[self performSelector:sortSelector withObject:other];
				else
					return NSOrderedSame;
			else if (mine < theirs)
				return NSOrderedAscending;
			else
				return NSOrderedDescending;
		case SORT_DESCENDING:
			if (mine == theirs)
				return NSOrderedSame;
			else if (mine < theirs)
				return NSOrderedDescending;
			else
				return NSOrderedAscending;
		default:
			NSLog(@"Invalid sort direction %d in compareUnsignedInts!", sortDirection);
			return NSOrderedSame;
	}
}

/* this compares the two NSStrings mine and theirs
 * if the two are the same, we compare self with other using
 * the sort selector newSortSelector
 */
- (NSComparisonResult)compareStrings:(NSString *)mine withOther:(NSString *)theirs withItem:(MyItem *)other withSortSelector:(SEL)newSortSelector
{
	switch ([mine caseInsensitiveCompare:theirs])
	{
		case NSOrderedSame:
			if (sortSelector != nil && sortSelector != newSortSelector)
				return (NSComparisonResult)[self performSelector:sortSelector withObject:other];
			else
				return NSOrderedSame;
		case NSOrderedAscending:
			if (sortDirection == SORT_ASCENDING)
				return NSOrderedAscending;
			else
				return NSOrderedDescending;
		case NSOrderedDescending:
			if (sortDirection == SORT_ASCENDING)
				return NSOrderedDescending;
			else
				return NSOrderedAscending;
	}
	// should never get here
	NSLog(@"Invalid comparison result in compareStrings:...");
	return NSOrderedSame;
}

@end
